/*
 * Decompiled with CFR 0.152.
 */
package BryceGraphs.Algorithms;

import BryceGraphs.ADTs.AdjacencyNode;
import Data_Structures.Structures.Fast.FastQueue;
import Data_Structures.Structures.HashTable;
import Data_Structures.Structures.HashingClasses.AArray;
import Data_Structures.Structures.SingleLinkedList;
import util.interfaces.Consumer1;

public class GraphSearch {
    public static <E extends AdjacencyNode<E>> AArray<E, SingleLinkedList<E>> shortestPaths(E start) {
        FastQueue<AdjacencyNode> Q = new FastQueue<AdjacencyNode>();
        AArray<AdjacencyNode, SingleLinkedList> paths_to_start = new AArray<AdjacencyNode, SingleLinkedList>(5);
        Q.enq(start);
        SingleLinkedList<E> L = new SingleLinkedList<E>();
        L.add(start);
        paths_to_start.insert(start, L);
        while (!Q.isEmpty()) {
            AdjacencyNode node = (AdjacencyNode)Q.deq();
            SingleLinkedList node_path = (SingleLinkedList)paths_to_start.lookup(node);
            for (AdjacencyNode n : node.getNeighbors()) {
                if (paths_to_start.lookup(n) != null) continue;
                SingleLinkedList shortest_path = (SingleLinkedList)node_path.push_static(n);
                paths_to_start.insert(n, shortest_path);
                Q.enq(n);
            }
        }
        return paths_to_start;
    }

    public static <Node extends AdjacencyNode<Node>> void BFS(Node root, Consumer1<Node> func2) {
        HashTable<AdjacencyNode> visited = new HashTable<AdjacencyNode>();
        FastQueue<AdjacencyNode> frontier = new FastQueue<AdjacencyNode>();
        frontier.enq(root);
        while (!frontier.isEmpty()) {
            AdjacencyNode node = (AdjacencyNode)frontier.deq();
            if (visited.contains(node)) continue;
            func2.eval(node);
            visited.add(node);
            for (AdjacencyNode n : node.getNeighbors()) {
                frontier.enq(n);
            }
        }
    }
}

